﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VIRP_WEB.BaseCode;

namespace VIRP_WEB.Custom.BPR.QuestionTool
{
    public partial class ToolQuestionList : BprBasePage
    {
        private ServiceInterfaceManager toolManager = new ServiceInterfaceManager();

        //    protected void Page_Load(object sender, EventArgs e)
        //    {
        //    }
        public override string MenuItemName()
        {
            return "Question List";
        }
        public override string AppObjectCode()
        {
            return "AHOBPR TOOL";
        }
        public override string TopMenuName()
        {
            return "Tool";
        }

        protected void ButtonClear_Click(object sender, EventArgs e)
        {
            TextBoxKeyWords.Text = "";
            DropDownListQuestionType.SelectedIndex = -1;
            DropDownListStatus.SelectedIndex = -1;
            HiddenFieldClearFlag.Value = "1";
        }

        protected void ButtonSearch_Click(object sender, EventArgs e)
        {
            GridViewQuestions.DataBind();
            HiddenFieldClearFlag.Value = "0";
        }

        protected void GridViewQuestions_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            try
            {
                int questionId = Convert.ToInt32(e.CommandArgument);

                switch (e.CommandName)
                {
                    case "Edit":
                        Response.Redirect($"ToolQuestionEdit.aspx?id={questionId}");
                        break;
                    case "Preview":
                        Response.Redirect($"ToolQuestionPreview.aspx?id={questionId}");
                        break;
                    case "DELETE_FLAG":
                        if (toolManager.RemoveQuestion(questionId))
                        {
                            GridViewQuestions.DataBind();
                            Alert.ShowDeleteSuccessful();
                        }
                        else
                        {
                            Alert.ShowSaveFailed();
                        }

                        break;
                    case "UPDATE_FLAG":
                        if (toolManager.ActivateDeactivateQuestion(User.Identity.Name, questionId))
                        {
                            GridViewQuestions.DataBind();
                            Alert.ShowSaveSuccess();
                        }
                        else
                        {
                            Alert.ShowSaveFailed();
                        }
                        break;
                }
            }
            catch
            {
                //do nothing.
                // this is for sorting only.
            }

            GridViewQuestions.SelectedIndex = -1;
        }

        protected void GridViewQuestions_RowDataBound(Object sender, GridViewRowEventArgs e)
        {
        }

        protected void GridViewPageSizeDdlChanged(Object sender, EventArgs e)
        {
            GridViewQuestions.PageSize = int.Parse(gridViewPageSizeDdl.SelectedValue);
        }
    }
}